unit fWVPregLacStatusUpdate;
{
  ================================================================================
  *
  *       Application:  TDrugs Patch OR*3*377 and WV*1*24
  *       Developer:    PII                 
  *       Site:         Salt Lake City ISC
  *
  *       Description:  Update form to enter the appropriate information for
  *                     pregnancy and lactation data. Caller supplies the
  *                     appropriate patient via the TWVPatient object as
  *                     an IWVPaitent interface.
  *
  *       Notes:
  *
  ================================================================================
}

interface

uses
  System.Actions,
  System.Classes,
  System.SysUtils,
  System.UITypes,
  System.Variants,
  Vcl.ActnList,
  Vcl.ComCtrls,
  Vcl.Controls,
  Vcl.Dialogs,
  Vcl.ExtCtrls,
  Vcl.Forms,
  Vcl.Graphics,
  Vcl.Menus,
  Vcl.StdCtrls,
  Winapi.Messages,
  Winapi.Windows,
  iWVInterface,
  VAUtils;

type
  TfrmWVPregLacStatusUpdate = class(TForm)
    btnCancel: TButton;
    btnSave: TButton;
    pnlOptions: TPanel;
    pnlPregnancyStatus: TPanel;
    bvlMedicallyAbleToConceive: TBevel;
    robnAbleToConceiveYes: TRadioButton;
    robnAbleToConceiveNo: TRadioButton;
    ckbxMenopause: TCheckBox;
    ckbxHysterectomy: TCheckBox;
    stxtAbleToConceive: TStaticText;
    stxtCurrentlyPregnant: TStaticText;
    robnPregnantYes: TRadioButton;
    robnPregnantNo: TRadioButton;
    robnPregnantUnsure: TRadioButton;
    dtpLastMenstrualPeriod: TDateTimePicker;
    stxtLastMenstrualPeriod: TStaticText;
    pnlLactationStatus: TPanel;
    bvlLactationStatus: TBevel;
    robnLactatingYes: TRadioButton;
    robnLactatingNo: TRadioButton;
    bvlPregnancyStatus: TBevel;
    stxtLactationStatus: TStaticText;
    ckbxPermanent: TCheckBox;
    pnlEddMethod: TPanel;
    pnlMedicallyAbleToConceive: TPanel;
    pnlPregnantStates: TPanel;
    stxtEDDMethod: TStaticText;
    stxtReaderStop: TStaticText;

    procedure AbleToConceiveYesNo(Sender: TObject);
    procedure PregnantYesNoUnsure(Sender: TObject);
    procedure dtpLastMenstrualPeriodChange(Sender: TObject);
    procedure CheckOkToSave(Sender: TObject);
    procedure robnLactatingYesNoClick(Sender: TObject);
  private
    { Private declarations }
    fDFN: string;
  public
    function Execute: Boolean;
    function GetData(aList: TStringList): Boolean;
  end;

function NewPLUpdateForm(aDFN: string): TfrmWVPregLacStatusUpdate;

implementation

{$R *.dfm}


const
  { Names for Name=Value pairs }
  SUB_ABLE_TO_CONCEIVE = 'ABLE TO CONCEIVE';
  SUB_LACTATION_STATUS = 'LACTATION STATUS';
  SUB_LAST_MENSTRUAL_PERIOD = 'LAST MENSTRUAL PERIOD DATE';
  SUB_MEDICAL_REASON = 'MEDICAL REASON';
  SUB_PATIENT = 'PATIENT';
  SUB_PREGNANCY_STATUS = 'PREGNANCY STATUS';

function NewPLUpdateForm(aDFN: string): TfrmWVPregLacStatusUpdate;
var
  i: integer;
begin
  Result := TfrmWVPregLacStatusUpdate.Create(Application.MainForm);

  with Result do
    begin
      Loaded;
      Position := poMainFormCenter;
      fDFN := aDFN;
      pnlMedicallyAbleToConceive.Visible := True;
      pnlPregnancyStatus.Visible := True;
      pnlLactationStatus.Visible := True;

      i := pnlOptions.Height + pnlOptions.Margins.Top + pnlOptions.Margins.Bottom;

      if pnlLactationStatus.Visible then
        i := i + pnlLactationStatus.Height + pnlLactationStatus.Margins.Top + pnlLactationStatus.Margins.Bottom;

      if pnlPregnancyStatus.Visible then
        i := i + pnlPregnancyStatus.Height + pnlPregnancyStatus.Margins.Top + pnlPregnancyStatus.Margins.Bottom;

      if pnlMedicallyAbleToConceive.Visible then
        i := i + pnlMedicallyAbleToConceive.Height + pnlMedicallyAbleToConceive.Margins.Top + pnlMedicallyAbleToConceive.Margins.Bottom;

      ClientHeight := i;
    end;
end;

procedure TfrmWVPregLacStatusUpdate.CheckOkToSave(Sender: TObject);
begin
  if robnAbleToConceiveYes.Checked then
    btnSave.Enabled := robnPregnantYes.Checked or robnPregnantNo.Checked or robnPregnantUnsure.Checked
  else if robnAbleToConceiveNo.Checked then
    btnSave.Enabled := ckbxHysterectomy.Checked or ckbxMenopause.Checked or ckbxPermanent.Checked
  else if robnLactatingYes.Checked or robnLactatingNo.Checked then
    btnSave.Enabled := True
  else
    btnSave.Enabled := False;
end;

procedure TfrmWVPregLacStatusUpdate.robnLactatingYesNoClick(Sender: TObject);
begin
  CheckOkToSave(Sender);
end;

procedure TfrmWVPregLacStatusUpdate.dtpLastMenstrualPeriodChange(Sender: TObject);
begin
  dtpLastMenstrualPeriod.Format := '';
end;

procedure TfrmWVPregLacStatusUpdate.AbleToConceiveYesNo(Sender: TObject);
begin
  if robnAbleToConceiveYes.Checked then
    begin
      ckbxMenopause.Checked := False;
      ckbxMenopause.Enabled := False;
      ckbxHysterectomy.Checked := False;
      ckbxHysterectomy.Enabled := False;
      ckbxPermanent.Checked := False;
      ckbxPermanent.Enabled := False;

      robnPregnantYes.Enabled := True;
      robnPregnantYes.TabStop := True;
      robnPregnantNo.Enabled := True;
      robnPregnantUnsure.Enabled := True;

      stxtLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Format := ' ';
      stxtEDDMethod.Enabled := False;
    end
  else if robnAbleToConceiveNo.Checked then
    begin
      ckbxMenopause.Enabled := True;
      ckbxHysterectomy.Enabled := True;
      ckbxPermanent.Enabled := True;

      robnPregnantYes.Enabled := False;
      robnPregnantYes.Checked := False;
      robnPregnantNo.Enabled := False;
      robnPregnantNo.Checked := False;
      robnPregnantUnsure.Enabled := False;
      robnPregnantUnsure.Checked := False;

      stxtLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Format := ' ';
      stxtEDDMethod.Enabled := False;
    end
  else
    begin
      ckbxMenopause.Checked := False;
      ckbxMenopause.Enabled := False;
      ckbxHysterectomy.Checked := False;
      ckbxHysterectomy.Enabled := False;
      ckbxPermanent.Checked := False;
      ckbxPermanent.Enabled := False;

      robnPregnantYes.Enabled := False;
      robnPregnantYes.Checked := False;
      robnPregnantNo.Enabled := False;
      robnPregnantNo.Checked := False;
      robnPregnantUnsure.Enabled := False;
      robnPregnantUnsure.Checked := False;

      stxtLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Enabled := False;
      dtpLastMenstrualPeriod.Format := ' ';
      stxtEDDMethod.Enabled := False;
    end;

  CheckOkToSave(Sender);
end;

procedure TfrmWVPregLacStatusUpdate.PregnantYesNoUnsure(Sender: TObject);
begin
    if robnPregnantYes.Checked then
      begin
        stxtLastMenstrualPeriod.Enabled := True;
        dtpLastMenstrualPeriod.Enabled := True;
        dtpLastMenstrualPeriod.DateTime := Now;
        dtpLastMenstrualPeriod.Format := ' ';
        stxtEDDMethod.Enabled := True;
        if ScreenReaderActive then
        begin
          stxtEDDMethod.TabStop := True;
          stxtEDDMethod.TabOrder := 4;
        end;
      end
    else
      begin
        stxtLastMenstrualPeriod.Enabled := False;
        dtpLastMenstrualPeriod.Enabled := False;
        dtpLastMenstrualPeriod.Format := ' ';
        stxtEDDMethod.Enabled := False;
      end;

  CheckOkToSave(Sender);
end;

function TfrmWVPregLacStatusUpdate.Execute: Boolean;
begin
  Result := (ShowModal = mrOk);
end;

function TfrmWVPregLacStatusUpdate.GetData(aList: TStringList): Boolean;
var
  aDateTime: TDateTime;
  y, m, d: Word;
  aStr: string;

  procedure AddReason(var aStr: string; aValue: string);
  begin
    if aStr <> '' then
      begin
        // Remove any previous 'and's
        if Pos(' and ', aStr) > 0 then
          aStr := StringReplace(aStr, ' and ', ', ', [rfReplaceAll]);
        // Append on this value with a gramatically correct 'and'
        aStr := Format('%s and %s', [aStr, aValue]);
        // Set capitialization to gramatically correct first char only
        aStr := UpperCase(Copy(aStr, 1, 1)) + LowerCase(Copy(aStr, 2, Length(aStr)));
      end
    else
      aStr := aValue;
  end;

begin
  aList.Clear;
  try
    aList.Values[SUB_PATIENT] := fDFN;

    if robnAbleToConceiveYes.Checked then
      begin
        aList.Values[SUB_ABLE_TO_CONCEIVE] := 'Yes';

        if robnPregnantYes.Checked then
          begin
            aList.Values[SUB_PREGNANCY_STATUS] := 'Yes';

            if dtpLastMenstrualPeriod.Format = '' then
              begin
                aDateTime := dtpLastMenstrualPeriod.DateTime;
                DecodeDate(aDateTime, y, m, d);
                aList.Values[SUB_LAST_MENSTRUAL_PERIOD] := IntToStr(((y - 1700) * 10000) + (m * 100) + d);
              end
          end
        else if robnPregnantNo.Checked then
          aList.Values[SUB_PREGNANCY_STATUS] := 'No'
        else if robnPregnantUnsure.Checked then
          aList.Values[SUB_PREGNANCY_STATUS] := 'Unsure'
        else
          aList.Values[SUB_PREGNANCY_STATUS] := 'Unknown';
      end
    else if robnAbleToConceiveNo.Checked then
      begin
        aList.Values[SUB_ABLE_TO_CONCEIVE] := 'No';
        aStr := '';

        if ckbxHysterectomy.Checked then
          AddReason(aStr, ckbxHysterectomy.Caption);

        if ckbxMenopause.Checked then
          AddReason(aStr, ckbxMenopause.Caption);

        if ckbxPermanent.Checked then
          AddReason(aStr, ckbxPermanent.Caption);

        aList.Values[SUB_MEDICAL_REASON] := aStr;
      end;

    if robnLactatingYes.Checked then
      aList.Values[SUB_LACTATION_STATUS] := 'Yes'
    else if robnLactatingNo.Checked then
      aList.Values[SUB_LACTATION_STATUS] := 'No';

    Result := True;
  except
    on e: Exception do
      begin
        aList.Clear;
        aList.Add('-1^' + e.Message);
        Result := False;
      end;
  end;
end;

end.
